/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.config;

import com.google.common.collect.ImmutableMultimap;
import dev.xkmc.l2artifacts.content.core.StatEntry;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFeature;
import dev.xkmc.l2artifacts.network.NetworkManager;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

@SerialClass
public class StatTypeConfig
extends BaseConfig
implements IArtifactFeature.Sprite {
    @SerialClass.SerialField
    public double base;
    @SerialClass.SerialField
    public double base_low;
    @SerialClass.SerialField
    public double base_high;
    @SerialClass.SerialField
    public double main_low;
    @SerialClass.SerialField
    public double main_high;
    @SerialClass.SerialField
    public double sub_low;
    @SerialClass.SerialField
    public double sub_high;
    @SerialClass.SerialField
    public Attribute attr;
    @SerialClass.SerialField
    public AttributeModifier.Operation op;
    @SerialClass.SerialField
    public boolean usePercent;
    @SerialClass.SerialField
    public ResourceLocation icon;

    public static StatTypeConfig get(ResourceLocation id) {
        return (StatTypeConfig)NetworkManager.STAT_TYPES.getEntry(id);
    }

    public static Collection<StatTypeConfig> getValues() {
        return NetworkManager.STAT_TYPES.getAll();
    }

    public void getModifier(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, StatEntry entry, UUID uuid) {
        builder.put((Object)this.attr, (Object)new AttributeModifier(uuid, entry.getName(), entry.getValue(), this.op));
    }

    public double getInitialValue(RandomSource random, boolean max) {
        return max ? this.base_high : Mth.m_216263_((RandomSource)random, (double)this.base_low, (double)this.base_high);
    }

    public double getMainValue(RandomSource random, boolean max) {
        return max ? this.main_high : Mth.m_216263_((RandomSource)random, (double)this.main_low, (double)this.main_high);
    }

    public double getSubValue(RandomSource random, boolean max) {
        return max ? this.base_high : Mth.m_216263_((RandomSource)random, (double)this.sub_low, (double)this.sub_high);
    }

    public MutableComponent getValueText(double val) {
        MutableComponent ans = Component.m_237113_((String)"+");
        ans = ans.m_130946_(ItemStack.f_41584_.format(this.usePercent ? val * 100.0 : val));
        if (this.usePercent) {
            ans = ans.m_130946_("%");
        }
        return ans;
    }

    public Component getTooltip(double val) {
        boolean neg = val < 0.0 ^ AttrTooltip.isNegative((Attribute)this.attr);
        return Component.m_237110_((String)("attribute.modifier.plus." + (this.usePercent ? 1 : 0)), (Object[])new Object[]{ItemStack.f_41584_.format(this.usePercent ? val * 100.0 : val), Component.m_237115_((String)this.attr.m_22087_())}).m_130940_(neg ? ChatFormatting.RED : ChatFormatting.BLUE);
    }

    @Override
    public ResourceLocation getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        ResourceLocation rl = this.getID();
        return new ResourceLocation(rl.m_135827_(), "textures/stat_type/" + rl.m_135815_() + ".png");
    }

    @Override
    public MutableComponent getDesc() {
        return Component.m_237115_((String)("stat_type." + this.getID().m_135827_() + "." + this.getID().m_135815_()));
    }

    public double getBaseValue() {
        return this.base;
    }
}

